package com.futronictech.fs28;

import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.bluetooth.BluetoothSerialPort;
import net.rim.device.api.bluetooth.BluetoothSerialPortInfo;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.LabelField;


/**
 * A class extending the MainScreen class, which provides default standard
 * behavior for BlackBerry GUI applications.
 */
public final class AppScreen extends MainScreen
{
    private BluetoothSerialPortInfo[] _portInfo;
    /**
     * Creates a new AppScreen object
     */
    public AppScreen()
    {        
        // Set the displayed title of the screen       
        setTitle("FS28 Bluetooth Master Mode Demo V3.0");
        // Determine if this BlackBerry model or simulator supports Bluetooth
        if (BluetoothSerialPort.isSupported())
        {
            // Get the BluetoothSerialPortInfo.  Retrieves serial port information for
            // the currently paired devices.
            _portInfo = BluetoothSerialPort.getSerialPortInfo();
            int numServices = _portInfo.length;

            // Create a MenuItem for each Bluetooth device we can connect to.
            for (int count = numServices - 1; count >= 0; --count)
            {
                String strDeviceName = _portInfo[count].getDeviceName();               
                // Add a menu item only to the service that corresponds to the "FS28" connection, 
                if (strDeviceName.equals("FS28"))
                {
                    DeviceMenuItem deviceMenuItem = new DeviceMenuItem("Connect to: " + strDeviceName, _portInfo[count]);
                    addMenuItem(deviceMenuItem);
                }
            }

            addMenuItem(_listenItem);
        }
        else
        {
            add(new LabelField("Bluetooth is not supported on this device."));
        }
    }
    
    ////////////////////////////////////////////////////////////
    //                  Menu Items                            //
    ////////////////////////////////////////////////////////////
    
    private MenuItem _listenItem = new MenuItem("Listen for FS28", 30, 30)
    {
        /**
         * Launches a connection waiting screen.
         *         
         * @see java.lang.Runnable#run()
         */
        public void run() 
        {
            UiApplication.getUiApplication().pushScreen(new SPPScreen(null));
            //close(); // Close the current screen            
        }
    };    
    
    /**
     * This is a custom menu item which invokes a connection to a paired device
     * when selected. 
     */
    private final class DeviceMenuItem extends MenuItem 
    {        
        private BluetoothSerialPortInfo _info;
     
        /**
         * Constructs the device menu item to allow the user to connect to a 
         * paired device.
         *  
         * @param text The label of the menu item to display
         * @param info The Bluetooth Serial Port information of the paired device this menu item will invoke a connection to
         */           
        DeviceMenuItem(String text, BluetoothSerialPortInfo info) {
            super(text, 20, 20);
            _info = info;
        }
        
        /**
         * Invokes the connection to the device associated with the Bluetooth 
         * Serial Port information stored in this object.
         * 
         * @see java.lang.Runnable#run()
         */
        public void run() {
            UiApplication.getUiApplication().pushScreen(new SPPScreen(_info));
            //close(); // Close the current screen            
        }
    };
}
